/*
---------------------- Apache Version 2.0 License ----------------------
Copyright 2023 René Steger

Licensed under the Apache License, Version 2.0 (the "License");
you may not use this file except in compliance with the License.
You may obtain a copy of the License at

    http://www.apache.org/licenses/LICENSE-2.0

Unless required by applicable law or agreed to in writing, software
distributed under the License is distributed on an "AS IS" BASIS,
WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
See the License for the specific language governing permissions and
limitations under the License.
------------------------------------------------------------------------
*/

-- create an instance of the Rexx class
rexxHandler=.RexxAppHandler~new
-- the abstract "start" method will be served by rexxHandler
rxApp=BSFCreateRexxProxy(rexxHandler, ,"javafx.application.Application")
-- launch the application and invokes "start"
rxApp~launch(rxApp~getClass, .nil)

-- get Java Support
::REQUIRES "BSF.CLS"

-- the Rexx handler for javafx.application.Application
::CLASS RexxAppHandler

-- will be called by JavaFX
::METHOD start
-- accesses the primary stage
USE ARG primaryStage

-- setting title to the Stage
primaryStage~setTitle("Box_Transform")

-- get access to the JavaFX colors
col=bsf.loadClass("javafx.scene.paint.Color")

-- create the root node
root=.bsf~new("javafx.scene.Group")

-- create a box
box=.bsf~new("javafx.scene.shape.Box")
-- set the width, height and depth of the box
box~width=150
box~height=150
box~depth=150

-- set position of the box
translate=.bsf~new("javafx.scene.transform.Translate")
translate~x=400
translate~y=300
translate~z=0

-- add a shear transformation to the box
shear=.bsf~new("javafx.scene.transform.Shear")
shear~x=1.75
shear~y=1.25

-- add a scale transformation to the box
scale=.bsf~new("javafx.scene.transform.Scale")
scale~x=1.75
scale~y=0.75
scale~z=0.5

-- set rotation of the box
rotate=.bsf~new("javafx.scene.transform.Rotate")
point=.bsf~new("javafx.geometry.Point3D", 1, 1, 1)
rotate~angle=45
rotate~axis=point

-- add the transformations to the box
box~getTransforms~~add(translate)~~add(shear)~~add(scale)~~add(rotate)

-- add the object to the root node
root~getChildren~~add(box)

-- create a scene and put it on the stage
primaryStage~setScene(.bsf~new("javafx.scene.Scene", root, 800, 600, col~LIGHTGREY))
-- display the content of the stage
primaryStage~show